<?php
/**
 * Entry point for api_imagick.php or api_gd.php
 */

require_once(explode("wp-content", __FILE__)[0] . "wp-load.php");
require_once("tenandtwo-img-processor.php");

/* ------------------------------ */
// redirect to placeholder if API not active

$options = get_option( IMG_PROCESSOR_OPTS, array() );
if (empty($options['api_img_process']))
{
    $url = strtr(IMG_PROCESSOR_PLACEHOLDER, array(ABSPATH => '/'));
    header("Location: $url");
    exit;
}

/* ------------------------------ */

$IMG_DEFAULTS = array(
    'placeholder'   => IMG_PROCESSOR_PLACEHOLDER
    , 'output_file'     => null
    , 'output_type'     => null
    , 'output_dpi'      => null
    , 'output_nocache'  => false

    , 'transform'   => 'none'
    , 'width'       => 500  // resize|fit|fill|crop|zoom
    , 'height'      => 300
    , 'top'         => 20   // crop|trim|border
    , 'left'        => 20
    , 'bottom'      => 20
    , 'right'       => 20
    , 'axis'        => 'x'  // flip
    , 'degrees'     => 90   // rotate
    , 'percent'     => 100  // scale|zoom
    , 'focus'       => 'x'  // zoom
//     , 'color_r'     => 0    // colorize
//     , 'color_g'     => 0
//     , 'color_b'     => 0
//     , 'color_a'     => 0
//     , 'brightness'  => 20   // brightness
//     , 'contrast'    => 20   // contrast
//     , 'smooth'      => 20   // smooth
//     , 'block_size'  => 3    // pixelate
//     , 'advanced'    => true
    );

/* ------------------------------ */

if (IMG_PROCESSOR_IMAGICK)  // && false
{
    include("./includes/api_imagick.php");
}
else
{
    include("./includes/api_gd.php");
}
