<?php
/**
 * IMG Processor
 *
 * @package           tenandtwo-wp-plugins
 * @subpackage        tenandtwo-img-processor
 * @author            Ten & Two Systems
 * @copyright         2024 Ten & Two Systems
 * @license           GPL-2.0-or-later
 *
 * @wordpress-plugin
 * Plugin Name:       Ten&Two IMG Processor
 * Plugin URI:        https://wordpress.org/plugins/tenandtwo-img-processor/
 * Description:       Transform and cache images from local and remote sources using PHP's GD extension.
 * Version:           0.0.1
 * Requires PHP:      7.4
 * Requires at least: 5.2
 * Author:            Ten & Two Systems
 * Author URI:        https://imgproc.tenandtwo.com/
 * Text Domain:       tenandtwo-img-processor
 * Domain Path:       /languages
 * License:           GPL v2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */
defined( 'ABSPATH' ) or die( 'Not for browsing' );

define( 'IMG_PROCESSOR_DIR', plugin_dir_path( __FILE__ ) );
define( 'IMG_PROCESSOR_NAME', basename(IMG_PROCESSOR_DIR) );
define( 'IMG_PROCESSOR_VERSION', '0.0.1' );
define( 'IMG_PROCESSOR_DOCS', 'https://imgproc.tenandtwo.com/' );

define( 'IMG_PROCESSOR_OPTS', 'img_processor_options' );  // option name
defined('IMG_PROCESSOR_CACHE') or define('IMG_PROCESSOR_CACHE', IMG_PROCESSOR_DIR.'cache' );
defined('IMG_PROCESSOR_PLACEHOLDER') or define('IMG_PROCESSOR_PLACEHOLDER', IMG_PROCESSOR_DIR.'img/_missing.jpg' );

define( 'IMG_PROCESSOR_URL', strtr(IMG_PROCESSOR_DIR.'api.php', array(ABSPATH => '/')) );


/**
 * IMG_Processor_Plugin
 * All class methods static and hooked.
 */
class IMG_Processor_Plugin
{
    private static $initiated = false;
    public static $defaults = array();

    /**
     * init
     */
    public static function init() {
        if (self::$initiated) { return; }

        // register pages, setting, options
        if (is_admin() && current_user_can('manage_options'))
        {
            require_once(IMG_PROCESSOR_DIR.'includes/admin.php');
            IMG_Processor_Admin::init();

            require_once(IMG_PROCESSOR_DIR.'includes/notice.php');
            IMG_Processor_Notice::init();
        }
        require_once(IMG_PROCESSOR_DIR.'includes/util.php');

        // GD required ; Imagick optional
        define( 'IMG_PROCESSOR_GD',      extension_loaded('gd') );
        define( 'IMG_PROCESSOR_IMAGICK', extension_loaded('imagick') );  // && false

        if (!IMG_PROCESSOR_GD)
            { trigger_error("GD extension not available", E_USER_NOTICE); return; }
        if (!IMG_PROCESSOR_IMAGICK && WP_DEBUG)
            { trigger_error("Imagick extension not available", E_USER_NOTICE); }

        require_once(IMG_PROCESSOR_DIR.'includes/image_gd.php');
        require_once(IMG_PROCESSOR_DIR.'includes/image_imagick.php');

        // register wp-cli commands
        require_once(IMG_PROCESSOR_DIR.'includes/cli.php');
        IMG_Processor_CLI::init();

        // register shortcodes
        require_once(IMG_PROCESSOR_DIR.'includes/shortcode.php');
        IMG_Processor_Shortcode::init();

        self::$initiated = true;
    }

    /**
     * activate
     */
    public static function plugin_activation()
    {
        add_option( IMG_PROCESSOR_OPTS, array() );
        flush_rewrite_rules();
    }

    /**
     * deactivate
     */
    public static function plugin_deactivation()
    {
        flush_rewrite_rules();
    }

    /**
     * uninstall
     */
    public static function plugin_uninstall()
    {
        delete_option( IMG_PROCESSOR_OPTS );
    }


}  // end IMG_Processor_Plugin

/**
 * MAIN
 */
register_activation_hook(   __FILE__, array('IMG_Processor_Plugin', 'plugin_activation') );
register_deactivation_hook( __FILE__, array('IMG_Processor_Plugin', 'plugin_deactivation') );
register_uninstall_hook(    __FILE__, array('IMG_Processor_Plugin', 'plugin_uninstall') );

add_action( 'init', array('IMG_Processor_Plugin', 'init') );
